/*
 * Decompiled with CFR 0.152.
 */
package jade.core.messaging;

import jade.core.AID;
import jade.core.messaging.GenericMessage;
import jade.core.messaging.MessageManager;
import jade.lang.acl.ACLMessage;
import jade.util.Logger;
import jade.util.leap.HashMap;
import jade.util.leap.LinkedList;
import jade.util.leap.List;
import jade.util.leap.Map;
import jade.util.leap.RoundList;

class OutBox {
    private int size = 0;
    private int maxSize;
    private boolean overMaxSize = false;
    private final Map messagesByReceiver = new HashMap();
    private final RoundList messagesByOrder = new RoundList();
    private Logger myLogger;

    OutBox(int s) {
        this.maxSize = s;
        this.myLogger = Logger.getMyLogger(this.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLast(AID receiverID, GenericMessage msg, MessageManager.Channel ch) {
        ACLMessage acl;
        boolean logActivated = this.myLogger.isLoggable(4);
        if (logActivated) {
            this.myLogger.log(4, "Entering addLast for receiver " + receiverID.getName());
        }
        if (msg.getPayload() != null && (acl = msg.getACLMessage()) != null) {
            acl.setContent(null);
        }
        this.increaseSize(msg.length());
        OutBox outBox = this;
        synchronized (outBox) {
            Box b = (Box)this.messagesByReceiver.get(receiverID);
            if (logActivated) {
                String msgDebug = b == null ? "No box for receiver " + receiverID.getName() : "Box for receiver " + receiverID.getName() + " busy ?  " + b.isBusy();
                this.myLogger.log(4, msgDebug);
            }
            if (b == null) {
                b = new Box(receiverID);
                this.messagesByReceiver.put(receiverID, b);
                this.messagesByOrder.add(b);
                if (logActivated) {
                    this.myLogger.log(4, "Box created for receiver " + receiverID.getName());
                }
            }
            if (logActivated) {
                this.myLogger.log(4, "Message entered in box for receiver " + receiverID.getName());
            }
            b.addLast(new MessageManager.PendingMsg(msg, receiverID, ch, -1L));
            this.notifyAll();
        }
        if (logActivated) {
            this.myLogger.log(4, "Exiting addLast for receiver " + receiverID.getName());
        }
    }

    final synchronized MessageManager.PendingMsg get() {
        Box b = null;
        while ((b = this.getNextIdle()) == null) {
            try {
                if (this.myLogger.isLoggable(4)) {
                    this.myLogger.log(4, "Deliverer " + Thread.currentThread() + " go to sleep...");
                }
                this.wait();
                if (!this.myLogger.isLoggable(4)) continue;
                this.myLogger.log(4, "Deliverer " + Thread.currentThread() + " wake up");
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
        MessageManager.PendingMsg pm = b.removeFirst();
        this.decreaseSize(pm.getMessage().length());
        return pm;
    }

    private final Box getNextIdle() {
        int i = 0;
        while (i < this.messagesByOrder.size()) {
            Box b = (Box)this.messagesByOrder.get();
            if (!b.isBusy()) {
                b.setBusy(true);
                if (this.myLogger.isLoggable(4)) {
                    this.myLogger.log(4, "Setting box busy for receiver " + b.getReceiver().getName());
                }
                return b;
            }
            ++i;
        }
        return null;
    }

    final synchronized void handleServed(AID receiverID) {
        Box b;
        boolean logActivated = this.myLogger.isLoggable(4);
        if (logActivated) {
            this.myLogger.log(4, "Entering handleServed for " + receiverID.getName());
        }
        if ((b = (Box)this.messagesByReceiver.get(receiverID)).isEmpty()) {
            this.messagesByReceiver.remove(receiverID);
            this.messagesByOrder.remove(b);
            if (logActivated) {
                this.myLogger.log(4, "Removed box for receiver " + receiverID.getName());
            }
        } else {
            b.setBusy(false);
            if (logActivated) {
                this.myLogger.log(4, "Freeing box for receiver " + receiverID.getName());
            }
        }
        if (logActivated) {
            this.myLogger.log(4, "Exiting handleServed for " + receiverID.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void increaseSize(int k) {
        block7: {
            long sleepTime = 0L;
            OutBox outBox = this;
            synchronized (outBox) {
                this.size += k;
                if (this.size > this.maxSize) {
                    if (!this.overMaxSize) {
                        this.myLogger.log(9, "MessageManager queue size > " + this.maxSize);
                        this.overMaxSize = true;
                    }
                    sleepTime = (1 + (this.size - this.maxSize) / 1000000) * 100;
                }
            }
            if (sleepTime <= 0L) break block7;
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException ie) {}
        }
    }

    private void decreaseSize(int k) {
        this.size -= k;
        if (this.size < this.maxSize && this.overMaxSize) {
            this.myLogger.log(8, "MessageManager queue size < " + this.maxSize);
            this.overMaxSize = false;
        }
    }

    synchronized String[] getStatus() {
        Object[] boxes = this.messagesByOrder.toArray();
        String[] status = new String[boxes.length];
        int i = 0;
        while (i < boxes.length) {
            status[i] = boxes[i].toString();
            ++i;
        }
        return status;
    }

    private class Box {
        private final AID receiver;
        private boolean busy;
        private final List messages;

        public Box(AID r) {
            this.receiver = r;
            this.busy = false;
            this.messages = new LinkedList();
        }

        private AID getReceiver() {
            return this.receiver;
        }

        private void setBusy(boolean b) {
            this.busy = b;
        }

        private boolean isBusy() {
            return this.busy;
        }

        private void addLast(MessageManager.PendingMsg pm) {
            this.messages.add(pm);
        }

        private MessageManager.PendingMsg removeFirst() {
            return (MessageManager.PendingMsg)this.messages.remove(0);
        }

        private boolean isEmpty() {
            return this.messages.isEmpty();
        }

        public String toString() {
            return "(" + this.receiver.getName() + " :busy " + this.busy + " :message-cnt " + this.messages.size() + ")";
        }
    }
}

